from __future__ import annotations

import ctypes
import os
from datetime import datetime
from pathlib import Path


def is_running_as_admin() -> bool:
    if os.name != "nt":
        return False
    try:
        return bool(ctypes.windll.shell32.IsUserAnAdmin())
    except Exception:
        return False


def ensure_logs_directory() -> Path:
    base = Path.home() / "FZ-M1-Optimizer"
    base.mkdir(parents=True, exist_ok=True)
    return base


def timestamp() -> str:
    return datetime.now().strftime("%Y-%m-%d_%H-%M-%S")

